# # InvoiceCallback
Invoice Callback Object

```php
use Xendit\Invoice\InvoiceCallback;
```

## Properties

| Name | Type | Required | Description | Examples |
|------------|:-------------:|:-------------:|-------------|:-------------:|
| **id** | **string** | ☑️ | An invoice ID generated by Xendit | null |
| **external_id** | **string** | ☑️ | ID of your choice (typically the unique identifier of an invoice in your system) | null |
| **user_id** | **string** | ☑️ | Xendit Business ID | null |
| **status** | **string** | ☑️ | The status of the invoice. | null |
| **merchant_name** | **string** | ☑️ | The name of company or website | null |
| **amount** | **float** | ☑️ | Nominal amount for the invoice | null |
| **payer_email** | **string** |  | Email of the payer | null |
| **description** | **string** |  | Description for the invoice | null |
| **paid_amount** | **float** |  | Total amount paid for the invoice | null |
| **created** | **string** | ☑️ | The date and time when the invoice was created. | null |
| **updated** | **string** | ☑️ | The date and time when the invoice was last updated. | null |
| **currency** | **string** | ☑️ | The currency of the invoice. | null |
| **paid_at** | **string** |  | The date and time when the invoice was paid. | null |
| **payment_method** | **string** |  | The payment method used for the invoice. | null |
| **payment_channel** | **string** |  | The payment channel. | null |
| **payment_destination** | **string** |  | The payment destination. | null |
| **payment_details** | [**PaymentDetails**](PaymentDetails.md) |  |  | null |
| **payment_id** | **string** |  | The ID of the payment. | null |
| **success_redirect_url** | **string** |  | The URL to redirect to on successful payment. | null |
| **failure_redirect_url** | **string** |  | The URL to redirect to on payment failure. | null |
| **credit_card_charge_id** | **string** |  | The ID associated with a credit card charge (if applicable). | null |
| **items** | [**array**](InvoiceCallbackItem.md) |  |  | null |
| **fees** | [**array**](InvoiceFee.md) |  | An array of fees associated with the invoice. | null |
| **should_authenticate_credit_card** | **bool** |  | Indicates whether credit card authentication is required. | null |
| **bank_code** | **string** |  | The bank code for the bank details. | null |
| **ewallet_type** | **string** |  | The type of eWallet. | null |
| **on_demand_link** | **string** |  | The on-demand link. | null |
| **recurring_payment_id** | **string** |  | The ID of the recurring payment. | null |


[[Back to README]](../../README.md)
